<?php

namespace Cms\Model\Campsite;

use Cms\Model\CmsUserIdAwareTrait;
use Cms\Model\ScopeAwareModelTrait;
use Cms\Model\StampAwareModelTrait;
use POM\DomainObjectAbstract;

/**
 * Class CampsiteModel
 * @package Cms\Model\Campsite
 * @property int $id
 * @property string $name
 * @property string $name_ascii
 * @property string $acces
 * @property string $slug
 * @property string $siret
 * @property string $language
 * @property string $description
 * @property string $leader_name
 * @property string $manager_name
 * @property string $devise
 * @property \Cms\Model\Campsite\CampsiteState $state
 * @property \Cms\Model\Campsite\CampsiteType $type
 * @property bool $visible
 **/
class CampsiteModel extends DomainObjectAbstract
{
    use ScopeAwareModelTrait;
    use StampAwareModelTrait;
    use CmsUserIdAwareTrait;

    /** @var  int */
    protected $id;

    /** @var  string */
    protected $name;

    /** @var  string */
    protected $name_ascii;

    /** @var  string */
    protected $acces;

    /** @var  string */
    protected $slug;

    /** @var  string */
    protected $siret;

    /** @var  string */
    protected $language;

    /** @var  string */
    protected $description;

    /** @var  string */
    protected $leader_name;

    /** @var  string */
    protected $manager_name;

    /** @var  string */
    protected $devise;

    /** @var  \Cms\Model\Campsite\CampsiteState */
    protected $state;

    /** @var  \Cms\Model\Campsite\CampsiteType */
    protected $type;

    /** @var bool */
    protected $visible;
}
