<?php


namespace Cms\Route;

/**
 * Class UrlBuilderAwareTrait
 * @package Cms\Route
 */
trait UrlBuilderAwareTrait
{

    /** @var  UrlBuilder */
    protected $urlBuilder;

    /**
     * @param UrlBuilder $urlBuilder
     * @return $this
     */
    public function setUrlBuilder(UrlBuilder $urlBuilder)
    {
        $this->urlBuilder = $urlBuilder;
        return $this;
    }

    /**
     * @return UrlBuilder
     * @throws \DomainException
     */
    public function getUrlBuilder() : UrlBuilder
    {
        if (!$this->urlBuilder instanceof UrlBuilder) {
            throw new \DomainException('UrlBuilder is undefined');
        }
        return $this->urlBuilder;
    }
}
