<?php

namespace Cms\Search\Provider\Elastica;

use Traversable;

/**
 * Class ElasticSearchAggregation
 * @package Cms\Search\Provider\Elastica
 */
class ElasticSearchAggregation implements \IteratorAggregate
{

    /** @var \ArrayIterator  */
    private $buckets;

    /** @var array */
    private $aggregation;

    /**
     * ElasticSearchAggregation constructor.
     * @param array $aggregation
     */
    public function __construct(array $aggregation)
    {
        $this->buckets = new \ArrayIterator($aggregation['buckets'] ?? []);
        $this->aggregation = $aggregation;
    }

    /**
     * Retrieve an external iterator
     * @link http://php.net/manual/en/iteratoraggregate.getiterator.php
     * @return Traversable An instance of an object implementing <b>Iterator</b> or
     * <b>Traversable</b>
     * @since 5.0.0
     */
    public function getIterator() : \Traversable
    {
        return $this->buckets;
    }

    /**
     * @return array
     */
    public function getAggregation() : array
    {
        return $this->aggregation;
    }
}
