<?php

namespace Move\Http\Middleware;

use Psr\Http\Message\ServerRequestInterface;

/**
 * Class Session
 * @package Move\Http\Middleware
 */
class Session implements MiddlewareInterface
{
    /** @var string */
    private $name;

    /** @var null */
    private $id;

    /**
     * Session constructor.
     * @param string $name
     * @param null $id
     */
    public function __construct($name = 'default', $id = null)
    {
        $this->name = $name;
        $this->id = $id;
    }

    /**
     * @param ServerRequestInterface $request
     * @return ServerRequestInterface
     */
    public function __invoke(ServerRequestInterface $request)
    {
        return $this->handle($request);
    }

    /**
     * Handle the payload.
     * @param ServerRequestInterface $request
     * @return ServerRequestInterface
     */
    public function handle(ServerRequestInterface $request)
    {
        //Session name
        $name = $this->name ?: session_name();
        session_name($name);

        //Session id
        $id = $this->id;
        if (empty($id)) {
            $cookies = $request->getCookieParams();
            if (!empty($cookies[$name])) {
                $id = $cookies[$name];
            }
        }

        if (!empty($id)) {
            session_id($id);
        }

        session_start();

        foreach ($_SESSION as $k => $value) {
            $request = $request->withAttribute($k, $value);
        }

        return $request;
    }
}
