<?php

namespace Move\Template\Extensions;

use League\Plates\Engine;
use League\Plates\Extension\ExtensionInterface;

/**
 * Class ChangeCase
 * @package Move\Template\Extensions
 */
class ChangeCase implements ExtensionInterface
{

    /**
     * @param Engine $engine
     */
    public function register(Engine $engine)
    {
        $engine->registerFunction('uppercase', [$this, 'uppercaseString']);
        $engine->registerFunction('lowercase', [$this, 'lowercaseString']);
        $engine->registerFunction('titlecase', [$this, 'titlecaseString']);
    }

    /**
     * @param string $var
     * @return string
     */
    public function uppercaseString($var)
    {
        return mb_convert_case($var, MB_CASE_UPPER);
    }

    /**
     * @param string $var
     * @return string
     */
    public function lowercaseString($var)
    {
        return mb_convert_case($var, MB_CASE_LOWER);
    }

    /**
     * @param string $var
     * @return string
     */
    public function titlecaseString($var)
    {
        return mb_convert_case($var, MB_CASE_TITLE);
    }
}
