<?php

namespace Move\Template\Html;

use Move\Utils\TaggedItemCollection;

/**
 * Class RenderAllStrategy
 * @package Move\Template\Html
 */
class RenderAllStrategy implements RenderStrategyInterface
{
    /**
     * @var string
     */
    private $glue;

    /**
     * @var bool[]
     */
    private $rendered = false;

    /**
     * RenderAllStrategy constructor.
     * @param string $glue
     */
    public function __construct($glue = '')
    {
        $this->glue = $glue;
    }

    /**
     * Effectue le rendu d'une collection en suivant une strategie prédéfini
     * @param TaggedItemCollection $itemCollection
     * @param array $tags
     * @return string
     */
    public function render(TaggedItemCollection $itemCollection, array $tags)
    {
        if ($this->rendered === true) {
            return '';
        }

        // effectue un rendu total
        $itemRendered = array_map(function ($object) {
            return (string)$object;
        }, $itemCollection->getAll());

        // on bloc les prochain affichage
        $this->rendered = true;
        return implode($this->glue, $itemRendered);
    }

    /**
     * @return string
     */
    public function getGlue()
    {
        return $this->glue;
    }
}
