<?php

namespace Move\Command;

use Interop\Container\ContainerInterface;
use League\Tactician\Handler\CommandHandlerMiddleware;
use League\Tactician\Handler\CommandNameExtractor\CommandNameExtractor;
use League\Tactician\Handler\MethodNameInflector\MethodNameInflector;
use PHPUnit\Framework\TestCase;

class TacticianBusFactoryTest extends TestCase
{
    /** @var $container */
    public $container;

    /** @var $extractor */
    public $extractor;

    /** @var $inflector */
    public $inflector;

    /**
     * @inheritdoc
     */
    public function setUp()
    {
        $this->container = $this
            ->getMockBuilder(ContainerInterface::class)
            ->getMock();

        $this->extractor = $this
            ->getMockBuilder(CommandNameExtractor::class)
            ->getMock();

        $this->inflector = $this
            ->getMockBuilder(MethodNameInflector::class)
            ->getMock();

    }

    /**
     * @covers TacticianBusFactory::createContainerHandler
     */
    public function testCreateContainerHandler()
    {
        $cHandler = TacticianBusFactory::createContainerHandler( $this->container, [], null, null);
        $this->assertInstanceOf(CommandHandlerMiddleware::class, $cHandler);

        $cHandler = TacticianBusFactory::createContainerHandler( $this->container, [], $this->extractor, null);
        $this->assertInstanceOf(CommandHandlerMiddleware::class, $cHandler);

        $cHandler = TacticianBusFactory::createContainerHandler( $this->container, [], $this->extractor, $this->inflector);
        $this->assertInstanceOf(CommandHandlerMiddleware::class, $cHandler);
    }

    /**
     * @covers TacticianBusFactory::containerMap
     */
    public function testContainerMap()
    {
        $commandBus = TacticianBusFactory::containerMap($this->container, [], null, []);
        $this->assertInstanceOf(CommandBusInterface::class, $commandBus);

        $commandBus = TacticianBusFactory::containerMap($this->container, [], $this->inflector, []);
        $this->assertInstanceOf(CommandBusInterface::class, $commandBus);
    }

    /**
     * @covers TacticianBusFactory::mapToClassHandler
     */
    public function testMapToClassHandler()
    {
        $commandBus = TacticianBusFactory::mapToClassHandler($this->container, [], '', []);
        $this->assertInstanceOf(CommandBusInterface::class, $commandBus);
    }
}
