<?php


namespace Cms\Bundle\Member\Exception;

/**
 * Class FieldException
 * @package Cms\Bundle\Member\Exception
 */
class FieldException extends RuntimeException
{

    /** @var string */
    private $fieldname;

    /**
     * FieldMissingException constructor.
     * @param string $fieldname
     * @param int $code
     * @param \Exception|null $previous
     */
    public function __construct(
        string $fieldname,
        $code,
        \Exception $previous = null
    ) {
        $message = 'field ' . $fieldname . ' is invalid';
        parent::__construct($message, $code, $previous);
        $this->fieldname = $fieldname;
    }

    /**
     * @return string
     */
    public function getFieldName() : string
    {
        return $this->fieldname;
    }
}
