<?php


namespace Cms\Bundle\Newsletter;

use League\Container\ServiceProvider\AbstractServiceProvider;
use League\Container\ServiceProvider\BootableServiceProviderInterface;
use Move\Config;
use Move\Newsletter\Provider\ProviderInterface;
use Move\Newsletter\ProviderAwareInterface;
use Move\Newsletter\ProviderFactory;

/**
 * Class MailjetServiceProvider
 * @package Cms\Bundle\Newsletter
 */
class MailjetServiceProvider extends AbstractServiceProvider implements
    BootableServiceProviderInterface
{
    /** @var  string */
    protected $apiKey;

    /** @var  string */
    protected $apiSecret;

    /** @var  string */
    protected $idList;

    /** @var  string */
    protected $tplWelcomeId;

    /** @var array */
    protected $confirmOpts;

    /** @var array */
    protected $customProps;

    /**
     * SarbacaneServiceProvider constructor.
     * @param array|Config $config
     * @throws \InvalidArgumentException
     */
    public function __construct($config)
    {
        if ($config instanceof Config) {
            $config = $config->getArrayCopy();
        }
        if (!\is_array($config) || !isset($config['apiKey'], $config['apiSecret'], $config['idList'])) {
            throw new \InvalidArgumentException('config must have apiKey, apiSecret, idList properties');
        }
        $this->apiKey = $config['apiKey'];
        $this->apiSecret = $config['apiSecret'];
        $this->idList = $config['idList'];
        if (!empty($config['confirm'])) {
            $this->confirmOpts = $config['confirm'];
        }
        if (!empty($config['custom_props'])) {
            $this->customProps = $config['custom_props'];
        }
        $this->provides = [
            ProviderInterface::class,
        ];
    }

    /**
     * Use the register method to register items with the container via the
     * protected $this->container property or the `getContainer` method
     * from the ContainerAwareTrait.
     * @return void
     * @throws \InvalidArgumentException
     */
    public function register()
    {
        $provider = ProviderFactory::createMailJet(
            $this->apiKey,
            $this->apiSecret,
            $this->idList,
            $this->confirmOpts,
            $this->customProps
        );
        $this->container->share(ProviderInterface::class, $provider);
    }

    /**
     * Method will be invoked on registration of a service provider implementing
     * this interface. Provides ability for eager loading of Service Providers.
     * @return void
     */
    public function boot()
    {
        // ajoute le provider de newsletter
        $this->container->inflector(ProviderAwareInterface::class)
            ->invokeMethod('setProvider', [
                ProviderInterface::class,
            ]);
    }
}
