<?php


namespace Cms\Bundle\Newsletter;

use Cms\Client\Member\Model\MemberRestfulModel;
use Cms\Model\Member\MemberAttributeName;
use Move\Newsletter\Provider\ProviderInterface;

/**
 * Class NewsletterHelper
 * @package Cms\Bundle\Newsletter
 */
class NewsletterHelper
{

    /**
     * @param int $scopeId
     * @param \Cms\Client\Member\Model\MemberRestfulModel $memberModel
     * @return array
     */
    public static function getDatasetForProvider($scopeId, MemberRestfulModel $memberModel) : array
    {
        return [
            'Civilite' => (string)$memberModel->getAttributeValue($scopeId, MemberAttributeName::GENDER),
            'Nom' => $memberModel->getAttributeValue($scopeId, MemberAttributeName::LASTNAME),
            'Prenom' => $memberModel->getAttributeValue($scopeId, MemberAttributeName::FIRSTNAME),
            'Pays' => $memberModel->getAttributeValue($scopeId, MemberAttributeName::COUNTRY),
            'Ville' => $memberModel->getAttributeValue($scopeId, MemberAttributeName::CITY),
            'CodePostal' => $memberModel->getAttributeValue($scopeId, MemberAttributeName::POSTAL_CODE),
            'OptIn' => $memberModel
                ->getAttributeValue($scopeId, MemberAttributeName::INSCRIT_NEWS) ? 'oui' : 'non',
            'OptInPartenaire' => $memberModel
                ->getAttributeValue($scopeId, MemberAttributeName::INSCRIT_NEWS_PARTNER) ? 'oui' : 'non',
            'OptInDocument' => $memberModel
                ->getAttributeValue($scopeId, MemberAttributeName::INSCRIT_DOCUMENT) ? 'oui' : 'non',
        ];
    }

    /**
     * @param int $scopeId
     * @param \Cms\Client\Member\Model\MemberRestfulModel $memberModel
     * @param \Move\Newsletter\Provider\ProviderInterface $provider
     * @param array $customDataset
     */
    public static function setNewsletterFromModel(
        $scopeId,
        MemberRestfulModel $memberModel,
        ProviderInterface $provider,
        array $customDataset = []
    ) {
        // envoi dans la base de mailing
        $dataset = static::getDatasetForProvider($scopeId, $memberModel);
        $dataset = array_merge($dataset, $customDataset);
        try {
            $provider->insert($memberModel->email, $dataset);
        } catch (\Exception $e) {
        }
    }
}
