<?php

namespace Cms\Client\Campsite\Model;

use Cms\Model\Campsite\CampsitePackageModel;
use Cms\Model\Campsite\CampsitePackageProductModel;
use Cms\Model\Campsite\Product\ProductModel;

/**
 * Class PackageRestfulModel
 * @package Cms\Client\Campsite\Model
 * @property \Cms\Model\Campsite\CampsitePackageProductModel[] $products
 */
class CampsitePackageRestfulModel extends CampsitePackageModel
{

    /** @var  \Cms\Model\Campsite\CampsitePackageProductModel[] */
    protected $products;

    /**
     * @param \Cms\Model\Campsite\CampsitePackageProductModel $productModel
     * @return \Cms\Client\Campsite\Model\CampsitePackageRestfulModel
     */
    public function addProduct(
        CampsitePackageProductModel $productModel
    ) : CampsitePackageRestfulModel {
        $this->products = array_filter(
            $this->products,
            function (CampsitePackageProductModel $model) use ($productModel) {
                return $model->product_id !== $productModel->product_id;
            }
        );
        $this->products[] = $productModel;
        return $this;
    }

    /**
     * @param int|\Cms\Model\Campsite\Product\ProductModel $productId
     * @param string|null $value
     * @param string|null $note
     * @param int|null $quantity
     * @return \Cms\Client\Campsite\Model\CampsitePackageRestfulModel
     * @throws \InvalidArgumentException
     */
    public function setProduct(
        $productId,
        string $value = null,
        string $note = null,
        int $quantity = null
    ) : CampsitePackageRestfulModel {
        if ($productId instanceof ProductModel) {
            $productId = $productId->id;
        }
        if (!is_numeric($productId)) {
            throw new \InvalidArgumentException('productId must be numeric or ProductModel');
        }
        $productModel = (new CampsitePackageProductModel())->populate([
            'product_id' => $productId,
            'value' => $value,
            'note' => $note,
            'quantity' => $quantity,
        ]);
        return $this->addProduct($productModel);
    }
}
