<?php


namespace Cms\Extension;

use League\Plates\Engine;
use League\Plates\Extension\ExtensionInterface;

/**
 * Class DateFormatExtension
 * @package Cms\Extension
 */
class DateFormatExtension implements ExtensionInterface
{

    /**
     * @param Engine $engine
     */
    public function register(Engine $engine)
    {
        $engine->registerFunction('date_format', [$this, 'dateFormat']);
        $engine->registerFunction('date_strf', [$this, 'dateStrf']);
        $engine->registerFunction('date_diff', [$this, 'dateDiffFormat']);
    }

    /**
     * @param string|int|\DateTime $stamp
     * @return \DateTime|false|string
     */
    protected function dateCreate($stamp)
    {
        if (is_numeric($stamp)) {
            $stamp = "@$stamp";
        }
        $date = $stamp instanceof \DateTime ? $stamp : date_create($stamp);
        return $date;
    }

    /**
     * @param string|int|\DateTime $stamp
     * @param string|null $format
     * @param string|int|\DateTime $stampCompare
     * @return string
     */
    public function dateDiffFormat($stamp, $format = null, $stampCompare = null)
    {
        $dateCompare = $this->dateCreate($stampCompare ?: date_create());
        $date = $this->dateCreate($stamp);
        $dateDiff = date_diff($date, $dateCompare);
        if ($format) {
            return $dateDiff->format($format);
        }
        if ($dateDiff->days > 370) {
            return 'le ' . $date->format('d/m/Y');
        }
        if ($dateDiff->days > 35) {
            return $dateDiff->format('il y a %m mois');
        }
        if ($dateDiff->days > 1) {
            return $dateDiff->format('il y a %d jours');
        }
        if ($dateDiff->h > 1) {
            return $dateDiff->format('il y a %h heures');
        }
        if ($dateDiff->i > 1) {
            return $dateDiff->format('il y a %i minutes');
        }
        return $dateDiff->format('il y a quelques secondes');
    }

    /**
     * @param string|int|\DateTime $stamp
     * @param string $format
     * @return string
     */
    public function dateFormat($stamp, $format)
    {
        $date = $this->dateCreate($stamp);
        return $date->format($format);
    }

    /**
     * @param string|int|\DateTime $stamp
     * @param string $format
     * @return string
     */
    public function dateStrf($stamp, $format)
    {
        $date = $this->dateCreate($stamp);
        return strftime($format, $date->getTimestamp());
    }
}
