<?php

namespace Move\Command\Command;

/**
 * Interface SortCommandInterface
 * @package Move\Command\Command
 */
interface SortCommandInterface
{

    /**
     * @param string $name
     * @param string $sort
     * @return \Move\Command\Command\SortCommandInterface
     */
    public function withSortOnCol(string $name, $sort) : SortCommandInterface;

    /**
     * @param array $sortCols
     * @return SortCommandInterface
     */
    public function withSortCols(array $sortCols) : SortCommandInterface;

    /**
     * @return array
     */
    public function getSortCols() : array;

    /**
     * @param string $name
     * @return string|null
     */
    public function getSortOrder(string $name);

    /**
     * @param string $name
     * @return bool
     */
    public function isSortDESC(string $name) : bool;

    /**
     * @param string $name
     * @return bool
     */
    public function isSortASC(string $name) : bool;
}
