<?php

namespace Move\Search\Analyzer;

/**
 * Class ElasticAnalyzer
 * @package Move\Search\Analyzer
 */
class ElasticAnalyzer
{

    /** @var string */
    private $name;

    /** @var string */
    private $tokenizer;

    /** @var array */
    private $filters = [];

    /** @var array */
    private $charFilters = [];

    /**
     * ElasticAnalyzer constructor.
     * @param string $name
     * @param string $tokenizer
     */
    public function __construct(string $name, string $tokenizer)
    {
        $this->name = $name;
        $this->tokenizer = $tokenizer;
    }

    /**
     * @param string $name
     * @param array|null $filter
     * @return $this
     */
    public function setCharFilter(string $name, array $filter = null)
    {
        $this->charFilters[$name] = $filter;
        return $this;
    }

    /**
     * @param string $name
     * @param array $filter
     * @return $this
     */
    public function setFilter(string $name, array $filter = null)
    {
        $this->filters[$name] = $filter;
        return $this;
    }

    /**
     * @param string $name
     * @param string $type
     * @param array $opts
     * @return $this
     */
    public function setCustomFilter(string $name, string $type, array $opts = [])
    {
        $this->filters[$name] = array_merge($opts, [
            'type' => $type,
        ]);
        return $this;
    }

    /**
     * @return string
     */
    public function getName() : string
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function getTokenizer() : string
    {
        return $this->tokenizer;
    }

    /**
     * @return string[]
     */
    public function getCharFilterNames() : array
    {
        return array_keys($this->charFilters);
    }

    /**
     * @return array
     */
    public function getCharFilters() : array
    {
        return array_filter($this->charFilters);
    }

    /**
     * @return string[]
     */
    public function getFilterNames() : array
    {
        return array_keys($this->filters);
    }

    /**
     * @return array
     */
    public function getFilters() : array
    {
        return array_filter($this->filters);
    }
}
