<?php

namespace Move\Search\Analyzer;

/**
 * Class FrenchTextAnalyzer
 * @package Move\Search\Analyzer
 */
class FrenchTextAnalyzer extends ElasticAnalyzer
{

    /**
     * FrenchTextAnalyzer constructor.
     * @param string|null $name
     */
    public function __construct(string $name = null)
    {
        parent::__construct($name ?: 'french_text_analyzer', 'standard');
        $this
            ->setFilter('french_elision', PredefinedFilterAnalyzer::FILTER_FRENCH_ELISION)
            ->setFilter('delimiter', PredefinedFilterAnalyzer::FILTER_DELIMITER)
            ->setFilter('lowercase')
            ->setFilter('french_stop', PredefinedFilterAnalyzer::FILTER_FRENCH_STOP)
            ->setFilter('asciifolding')
            ->setFilter('french_stemmer', PredefinedFilterAnalyzer::FILTER_FRENCH_STEMMER);
    }
}
