<?php

namespace Move\Specification;

/**
 * Class PhpFilterSpecification
 * @package Move\Specification
 */
class PhpFilterVarSpecification extends Specification
{
    /**
     * @var int|callable
     */
    private $filter;

    /**
     * @var mixed
     */
    private $options;

    /**
     * PhpFilterSpecification constructor.
     * @see filter_var
     * @param int|callable $filter
     * @param mixed $options
     */
    public function __construct($filter = FILTER_DEFAULT, $options = [])
    {
        $this->filter = $filter;
        $this->options = $options;
    }

    /**
     * @param mixed $object
     * @return bool
     */
    public function isSatisfiedBy($object) : bool
    {
        if (\is_array($object)) {
            if ($this->filter === FILTER_CALLBACK && \is_callable($this->options['options'])) {
                $this->filter = $this->options['options'];
            }
            if (\is_callable($this->filter)) {
                foreach ($object as $value) {
                    $result = \call_user_func($this->filter, $value);
                    if (!\is_bool($result) || $result === false) {
                        return false;
                    }
                }
                return true;
            }

            return filter_var_array($object, $this->filter);
        }

        return filter_var($object, $this->filter, $this->options) !== false;
    }
}
