<?php

namespace Move\Jato;

use GuzzleHttp\Client;
use League\Tactician\CommandBus;
use Move\Command\CommandBusInterface;
use Move\Command\TactitianBusAdapter;
use Move\Http\Client\GuzzleClientAdapter;
use PHPUnit\Framework\TestCase;

/**
 * Class JatoServiceTest
 * @package Move\Jato
 */
class JatoServiceTest extends TestCase
{
    /**
     * @return JatoService
     */
    public function testConstruct() : JatoService
    {
        $email = 'nlegall@movepublishing.com';
        $password = 'king7queen';

        $client = new JatoClient(
            new GuzzleClientAdapter(new Client(), 'webapi-live.jato.com/jato.carspecs.api'), $email,
            $password
        );
        $commandBus = new TactitianBusAdapter(new CommandBus([]));
        $service = new JatoService($client, $commandBus);
        $this->assertInstanceOf(JatoService::class, $service, 'Not a JatoService');

        return $service;
    }

    /**
     * @depends testConstruct
     * @param JatoService $service
     */
    public function testGetClient(JatoService $service)
    {
        $client = $service->getClient();
        $this->assertInstanceOf(JatoClient::class, $client, 'Error getClient');
    }

    /**
     * @depends testConstruct
     * @param JatoService $service
     */
    public function testGetCommandBus(JatoService $service)
    {
        $commandBus = $service->getCommandBus();
        $this->assertInstanceOf(CommandBusInterface::class, $commandBus, 'Error getCommandBus');
    }

    /**
     * @depends testConstruct
     * @param JatoService $service
     */
    public function testSetClient(JatoService $service)
    {
        $email = 'nlegall@movepublishing.com';
        $password = 'king7queen';

        $newClient = new JatoClient(
            new GuzzleClientAdapter(new Client(), 'webapi-live.jato.com/jato.carspecs.api'), $email,
            $password
        );
        $service->setClient($newClient);
        $result = $service->getClient();

        $this->assertInstanceOf(JatoClient::class, $result, 'SetClient error');
    }

    /**
     * @depends testConstruct
     * @param JatoService $service
     */
    public function testSetCommandBus(JatoService $service)
    {
        $commandBus = new TactitianBusAdapter(new CommandBus([]));
        $service->setCommandBus($commandBus);
        $result = $service->getCommandBus();

        $this->assertInstanceOf(CommandBusInterface::class, $result, 'SetCommandBus error');
    }

}