<?php

namespace Move\Specification;

use PHPUnit\Framework\TestCase;

/**
 * Class NameSpecificationTest
 * @package Move\Specification
 */
class NameSpecificationTest extends TestCase
{
    /**
     * @return array
     */
    public static function provideNames()
    {
        return [
            ['aa', true],
            ['aa aa', true],
            ['aa-aa', true],
            ['aa-AA', true],

            ['a', false],
            ['@a', false],
            ['%a', false],
            ['!a', false],
            ['1a', false],
            ['  ', false],
            ['  +1', false],
            ['  -1', false],
            ['aa -AA', false],
            ['aa- AA', false],
        ];
    }
    /**
     * @covers NameSpecification::__construct
     */
    public function testConstruct()
    {
        $nameSpec = new NameSpecification();
        $this->assertInstanceOf(NameSpecification::class, $nameSpec);
    }

    /**
     * @depends testConstruct
     * @dataProvider provideNames
     * @param $value
     * @param $expected
     */
    public function testIsSatisfiedBy($value, $expected)
    {
        $nameSpec = new NameSpecification();
        $this->assertEquals($expected, $nameSpec->isSatisfiedBy($value));
    }
}
