<?php


namespace Cms\Client\Command\Member\Command;

use Move\Command\Command\FetchCommand;

/**
 * Class FetchMemberCommand
 * @package Cms\Client\Command\Member\Command
 */
class FetchMemberCommand extends FetchCommand
{

    /** @var bool */
    private $allowAll;

    /**
     * FetchMemberCommand constructor.
     * @param mixed $id
     * @param bool $allowAll
     */
    public function __construct($id, $allowAll = false)
    {
        parent::__construct($id);
        $this->allowAll = $allowAll;
    }

    /**
     * @deprecated
     * @return boolean
     */
    public function isAllowAll()
    {
        return $this->allowAll;
    }

    /**
     * @param boolean $allowAll
     * @return $this
     */
    public function setAllowAll($allowAll)
    {
        $this->allowAll = $allowAll;
        return $this;
    }
}
