<?php


namespace Cms\Client\Geodata\Model;

use Cms\Model\Geodata\AdminModel;

/**
 * Class AdminRestfulModel
 * @package Cms\Client\Geodata\Model
 * @property AdminRestfulModel $parent
 * @property bool $old_region_fr
 * @property \Cms\Model\Geodata\CountryModel $country
 * @property \Cms\Model\Geodata\AdminI18nModel[] $i18n
 */
class AdminRestfulModel extends AdminModel
{

    /** @var  AdminRestfulModel */
    protected $parent;

    /** @var  \Cms\Model\Geodata\CountryModel */
    protected $country;

    /** @var  \Cms\Model\Geodata\AdminI18nModel[] */
    protected $i18n;

    /** @var  bool */
    protected $old_region_fr;

    /**
     * @param string $offset
     * @return \Cms\Model\Geodata\CountryModel|mixed
     */
    public function propertyGet($offset)
    {
        // récuperation du pays du parent le plus haut
        if ($offset === 'country' && $this->parent) {
            return $this->parent->country;
        }
        return parent::propertyGet($offset);
    }
}
