<?php

namespace Cms\Model\Contract\Product;

use Cms\LinkResource\AbstractLinkResourceCollection;

/**
 * Class ProductLinkResourceCollection
 * @package Cms\Model\Contract\Product
 */
class ProductResourceCollection extends AbstractLinkResourceCollection
{
    /**
     * @param array|\Cms\LinkResource\AbstractLinkResourceModel $resourceData
     * @return ProductResourceModel
     */
    public function handleResource($resourceData)
    {
        if (!$resourceData instanceof ProductResourceModel) {
            $resourceData = (new ProductResourceModel())->populate($resourceData, true);
        }
        return $resourceData;
    }
}
