<?php


namespace Cms\Search;

/**
 * Class ElasticFunctionScoreFactory
 * @package Cms\Search
 */
class ElasticFunctionScoreFactory
{

    /**
     * @param array $functions
     * @param array $query
     * @param array $opts
     * @return array
     */
    public static function createGlobalFunctionScore(array $functions, array $query = [], array $opts = []) : array
    {
        $functionParam = [
            'query' => $query ?: ['match_all' => new \stdClass()],
            'functions' => $functions,
        ];
        $query = [
            'function_score' => array_merge($functionParam, $opts),
        ];

        return $query;
    }

    /**
     * @param array $filter
     * @param string $functionType
     * @param array|string $functionParams
     * @param int|null $weight
     * @return array
     */
    public static function createFilterFunction(
        array $filter,
        string $functionType,
        $functionParams,
        int $weight = null
    ) : array {
        $query = [
            'filter' => $filter,
            $functionType => $functionParams,
        ];
        if ($weight !== null) {
            $query['weight'] = $weight;
        }
        return $query;
    }
}
