<?php


namespace Move\Embed\Normalizer;

use Move\Embed\Parser\ParserInterface;

/**
 * Class GoogleMapsNormalizer
 * @package Move\Embed\Normalizer
 */
class GoogleMapsNormalizer implements NormalizerInterface
{
    public const MODE_IFRAME = 'iframe';

    public const MODE_STATIC = 'static';

    /** @var string */
    protected $staticSize;

    /** @var ParserInterface */
    private $parser;

    /** @var string */
    private $mode;

    /** @var null|string */
    private $gmapsApiKey;

    /**
     * GoogleMapsNormalizer constructor.
     * @param ParserInterface $parser
     * @param string|null $gmapsApiKey
     * @param string|null $mode
     */
    public function __construct(ParserInterface $parser, string $gmapsApiKey = null, string $mode = null)
    {
        $this->parser = $parser;
        $this->mode = $mode ?: static::MODE_IFRAME;
        $this->staticSize = '800x600';
        $this->gmapsApiKey = $gmapsApiKey;
    }

    /**
     * @param int $width
     * @param int $height
     * @return $this
     */
    public function setStaticSize(int $width, int $height)
    {
        $this->staticSize = $width . 'x' . $height;
        return $this;
    }

    /**
     * @param string $sourceUri
     * @return string
     * @throws \InvalidArgumentException
     */
    public function __invoke($sourceUri)
    {
        return $this->normalizeStr($sourceUri);
    }

    /**
     * @param string $str
     * @return string
     */
    public function normalizeStr($str)
    {
        if ($this->parser->matchString($str, $matches)) {
            if ($this->mode === static::MODE_IFRAME && !empty($matches[1])) {
                $str = 'https://www.google.com/maps/embed/v1/place'
                    . '?q=' . $matches[1]
                    . '&center=' . $matches[2] . ',' . $matches[3]
                    . '&zoom=' . $matches[4];
            } elseif ($this->mode === static::MODE_STATIC) {
                if (!empty($matches[2]) && !empty($matches[3])) {
                    $str = 'https://maps.googleapis.com/maps/api/staticmap'
                        . '?center=' . $matches[2] . ',' . $matches[3]
                        . '&zoom=' . $matches[4]
                        . '&size=' . $this->staticSize;
                } else {
                    $str = '';
                }
            }
            if (!empty($str)) {
                $str .= '&key=' . $this->gmapsApiKey;
            }
        }
        return $str;
    }
}
