<?php

namespace Move\Specification;

use PHPUnit\Framework\TestCase;

/**
 * Class BirthdateSpecification
 * @package Move\Specification
 */
class BirthdateSpecificationTest extends TestCase
{
    /**
     * @return array
     */
    public static function provideFormat()
    {
        return [
            ['d/m/y'],
            ['m/d/y'],
            ['y/m/d']
        ];
    }

    /**
     * @param $format
     * @dataProvider provideFormat
     * @covers BirthdateSpecification::isSatisfiedBy
     */
    public function testIsSatisfiedBy ($format)
    {
        $year = 3600 * 24 * 365;
        $minAge = 10;

        // age more than 110 years
        $birthdate = new BirthdateSpecification();

        $old = time() - 200 * $year;
        $this->assertFalse(
            $birthdate->isSatisfiedBy(date($format, $old))
        );

        // age less than minAge
        $young = time() - ($minAge - 1) * $year;
        $birthdate = new BirthdateSpecification($format, $minAge);
        $this->assertFalse(
            $birthdate->isSatisfiedBy(date($format, $young))
        );

        // age in range
        $normal = time() - ($minAge + 2) * $year;
        $birthdate = new BirthdateSpecification($format, $minAge);
        $this->assertTrue(
            $birthdate->isSatisfiedBy(date($format, $normal))
        );
    }

}
