<?php

namespace Cms\Client\Member;

use Cms\Client\AbstractClient;
use Cms\Client\CmsApiIndexIterator;
use Cms\Model\Member\MemberRewardModel;

/**
 * Class MemberRewardClient
 * @package Cms\Client\Member
 */
class MemberRewardClient extends AbstractClient
{
    /** @var string */
    protected $basePath = 'member/reward';

    /**
     * @param array $dataset
     * @return MemberRewardModel
     */
    public function handleData($dataset = [])
    {
        return (new MemberRewardModel())->populate($dataset);
    }

    /**
     * @param array $queryParams
     * @return CmsApiIndexIterator
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpServerException
     */
    public function getIndexWithParams($queryParams) : CmsApiIndexIterator
    {
        $result = $this->loadIndexFromClient($this->basePath, $queryParams);
        return $result;
    }

    /**
     * @param int $memberId
     * @param int $maxTotalUse
     * @param \string $activInterval
     * @return \Cms\Client\CmsApiIndexIterator
     */
    public function getActivRewards(int $memberId, int $maxTotalUse, string $activInterval) : CmsApiIndexIterator
    {
        return $this->getBuilder()->setFilter('member_id', $memberId)
            ->setFilter('max_total_use', $maxTotalUse)
            ->setFilter('activ_interval', $activInterval)
            ->getIndex(-1);
    }
}
