<?php


namespace Cms\Client\Navigation;

use Cms\Client\AbstractClient;
use Cms\Client\CmsApiIndexIterator;
use Cms\Client\Navigation\Model\NavigationItemRestfulModel;

/**
 * Class NavigationItemClient
 * @package Cms\Client\Navigation
 */
class NavigationItemClient extends AbstractClient
{

    /** @var string */
    protected $basePath = '/navigation/item';

    /**
     * @param array $dataset
     * @return NavigationItemRestfulModel
     */
    public function handleData($dataset = [])
    {
        return (new NavigationItemRestfulModel())->populate($dataset, true);
    }

    /**
     * @param array $queryParams
     * @return CmsApiIndexIterator|NavigationItemRestfulModel[]
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function getIndexWithParams($queryParams)
    {
        $result = $this->loadIndexFromClient($this->basePath, $queryParams);
        return $result;
    }

    /**
     * @param null $parentId
     * @param bool $invertOrder
     * @return Model\NavigationItemRestfulModel[]|CmsApiIndexIterator
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function getChildren($parentId = null, $invertOrder = false)
    {
        $result = $this->getIndexWithParams([
            'filter' => [
                'parent_id' => $parentId,
            ],
            'sort' => [
                'rank' => (bool)$invertOrder === true ? 'DESC' : 'ASC',
            ],
        ]);
        return $result;
    }

    /**
     * @param null|int $scope
     * @return Model\NavigationItemRestfulModel[]|CmsApiIndexIterator
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function getIndex($scope = null)
    {
        $result = $this->getIndexWithParams([
            'scope' => $scope,
        ]);
        return $result;
    }

    /**
     * @param null|int $scope
     * @param bool $invertOrder
     * @return Model\NavigationItemRestfulModel[]|CmsApiIndexIterator
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function getParents($scope = null, $invertOrder = false)
    {
        $result = $this->getIndexWithParams([
            'scope' => $scope,
            'filter' => [
                'parents' => true,
            ],
            'sort' => [
                'rank' => (bool)$invertOrder === true ? 'DESC' : 'ASC',
            ],
        ]);
        return $result;
    }

    /**
     * @param NavigationItemRestfulModel $object
     * @return NavigationItemRestfulModel|null
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function updateItem(NavigationItemRestfulModel $object)
    {
        $object = $this->saveItem($object);
        return $object;
    }

    /**
     * @param NavigationItemRestfulModel $object
     * @return bool|NavigationItemRestfulModel
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function createItem(NavigationItemRestfulModel $object)
    {
        $object = $this->saveItem($object);
        return $object;
    }
}
