<?php

namespace Cms\Client\Service;

use Cms\Client\CmsUser\CmsUserClient;
use Cms\Client\CmsUser\CmsUserSessionClient;

/**
 * Class CmsUserService
 * @package Cms\Client\Service
 */
class CmsUserService
{
    /** @var CmsUserClient */
    private $userClient;

    /** @var CmsUserSessionClient */
    private $sessionClient;

    /**
     * CmsUserService constructor.
     * @param CmsUserClient $userClient
     * @param CmsUserSessionClient $sessionClient
     */
    public function __construct(CmsUserClient $userClient, CmsUserSessionClient $sessionClient)
    {
        $this->userClient = $userClient;
        $this->sessionClient = $sessionClient;
    }

    /**
     * @return CmsUserClient
     */
    public function getUserClient()
    {
        return $this->userClient;
    }

    /**
     * @return CmsUserSessionClient
     */
    public function getSessionClient()
    {
        return $this->sessionClient;
    }
}
