<?php


namespace Cms\Client\Service;

/**
 * Trait MemberServiceAwareTrait
 * @package Cms\Client\Service
 */
trait MemberServiceAwareTrait
{

    /** @var  \Cms\Client\Service\MemberService */
    protected $memberService;

    /**
     * @param \Cms\Client\Service\MemberService $memberService
     * @return $this
     */
    public function setMemberService(MemberService $memberService)
    {
        $this->memberService = $memberService;
        return $this;
    }

    /**
     * @return \Cms\Client\Service\MemberService
     * @throws \DomainException
     */
    public function getMemberService() : MemberService
    {
        if (!$this->memberService instanceof MemberService) {
            throw new \DomainException('memberService is not a MemberService instance');
        }
        return $this->memberService;
    }
}
