<?php


namespace Cms\Client\Service;

/**
 * Trait SchedulerServiceAwareTrait
 * @package Cms\Client\Service
 */
trait SchedulerServiceAwareTrait
{

    /** @var  \Cms\Client\Service\SchedulerService */
    protected $schedulerService;

    /**
     * @param \Cms\Client\Service\SchedulerService $schedulerService
     * @return $this
     */
    public function setSchedulerService(SchedulerService $schedulerService)
    {
        $this->schedulerService = $schedulerService;
        return $this;
    }

    /**
     * @return \Cms\Client\Service\SchedulerService
     * @throws \DomainException
     */
    public function getSchedulerService() : SchedulerService
    {
        if (!$this->schedulerService instanceof SchedulerService) {
            throw new \DomainException('schedulerService is not a SchedulerService instance');
        }
        return $this->schedulerService;
    }
}
