<?php

namespace Cms\Model\Campsite\Thematic;

use Cms\Model\I18nModelInterface;
use Cms\Model\I18nModelTrait;
use POM\DomainObjectAbstract;

/**
 * Class ThematicI18nModel
 * @package Cms\Model\Campsite\Thematic
 * @property int $thematic_id
 * @property string $name
 * @property string $name_dyn
 * @property string $short_description
 * @property string $description
 */
class ThematicI18nModel extends DomainObjectAbstract implements I18nModelInterface
{
    use I18nModelTrait;

    /**
     * @relation
     * @var int
     */
    protected $thematic_id;

    /** @var  string */
    protected $name;

    /** @var  string */
    protected $slug;

    /** @var  int */
    protected $rank;

    /** @var  string */
    protected $name_dyn;

    /** @var  string */
    protected $short_description;

    /** @var  string */
    protected $description;
}
