<?php

namespace Cms\Model\CmsUser;

use Move\Filter\Filter;
use Move\Filter\Validator\AbstractDomainObjectStateValidator;
use Move\Specification\EmptySpecification;
use Move\Specification\EnumSpecification;

/**
 * Class CmsUserValidator
 * @package Cms\Model\CmsUser
 */
class CmsUserValidator extends AbstractDomainObjectStateValidator
{
    /**
     * @return Filter
     */
    protected function createFilter()
    {
        return new Filter([
            'email' => FILTER_VALIDATE_EMAIL,
            'password_hash' => true,
            'password_hash_type' => true,
            'state' => (new EmptySpecification())
                ->orSpec(new EnumSpecification(CmsUserState::class)),
        ], [
            'state' => function ($state) {
                return $state ?: CmsUserState::ONLINE;
            },
        ]);
    }
}
