<?php


namespace Move\Log;

use Monolog\Formatter\LineFormatter;
use Monolog\Handler\SyslogUdpHandler;
use Monolog\Logger;

/**
 * Class PapertailHandlerFactory
 * @package Move\Log
 */
class PapertailHandlerFactory
{

    /**
     * @param string $host
     * @param int $port
     * @param int|null $logLevel
     * @return \Monolog\Handler\SyslogUdpHandler
     */
    public static function create(
        string $host = 'logs3.papertrailapp.com',
        int $port = 21288,
        $logLevel = null
    ) : SyslogUdpHandler {
        // line formater
        $logFormatter = new LineFormatter();
        $logFormatter->ignoreEmptyContextAndExtra();

        // level
        $logLevel = $logLevel ?: Logger::ERROR;

        // handler
        $handler = new SyslogUdpHandler($host, $port, LOG_USER, $logLevel);
        $handler->setFormatter($logFormatter);

        return $handler;
    }
}
