<?php

namespace Move\Search\Analyzer;

/**
 * Class GeoFrenchAnalyzer
 * @package Move\Search\Analyzer
 */
class GeoFrenchAnalyzer extends ElasticAnalyzer
{
    /**
     * GeoFrenchAnalyzer constructor.
     * @param string|null $name
     */
    public function __construct(string $name = null)
    {
        parent::__construct($name ?: 'geo_french_analyzer', 'standard');
        $this
            ->setFilter('french_elision', PredefinedFilterAnalyzer::FILTER_FRENCH_ELISION)
            ->setFilter('lowercase')
            ->setFilter('asciifolding')
            ->setFilter('french_stop', PredefinedFilterAnalyzer::FILTER_FRENCH_STOP)
            ->setFilter('autocomplete', PredefinedFilterAnalyzer::FILTER_AUTOCOMPLETE);
    }
}
