<?php

namespace Move\Template\Extensions;

use League\Plates\Engine;
use League\Plates\Extension\ExtensionInterface;
use Move\Template\Html\Meta\MetaCollection;

/**
 * Class MetaHtml
 * @package Move\Template\Extensions
 */
class MetaHtml implements ExtensionInterface
{
    /**
     * @var MetaCollection
     */
    private $metaCollection;

    /**
     * MetaHtml constructor.
     * @param MetaCollection $metaCollection
     */
    public function __construct(MetaCollection $metaCollection)
    {
        $this->metaCollection = $metaCollection;
    }

    /**
     * @param Engine $engine
     */
    public function register(Engine $engine)
    {
        // gestion d'un precedent
        if ($engine->doesFunctionExist('meta')) {
            $callback = $engine->getFunction('meta')->getCallback();

            /** @var MetaCollection $metaCollection */
            $metaCollection = $callback[0]->getMetaCollection();
            $this->metaCollection = $metaCollection->mergeWith($this->metaCollection, true);

            $engine->dropFunction('meta');
        }
        $engine->registerFunction('meta', [$this, 'renderCollection']);
    }

    /**
     * @param array|string $tags
     * @return string
     */
    public function renderCollection($tags = [])
    {
        return $this->metaCollection->render($tags);
    }

    /**
     * @return MetaCollection
     */
    public function getMetaCollection()
    {
        return $this->metaCollection;
    }
}
