<?php


namespace Cms\Client\AddressBook;

use Cms\Client\AbstractClient;
use Cms\Client\AddressBook\Model\AddressRestfulModel;
use Cms\Client\CmsApiIndexIterator;

/**
 * Class AddressBookAddressClient
 * @package Cms\Client\AddressBook
 */
class AddressBookAddressClient extends AbstractClient
{

    /** @var string */
    protected $basePath = 'addressbook/address';

    /**
     * @param array $dataset
     * @return AddressRestfulModel
     */
    public function handleData($dataset = [])
    {
        return (new AddressRestfulModel())->populate($dataset ?: [], true);
    }

    /**
     * @return AddressBookAddressClientQueryBuilder
     */
    public function getBuilder()
    {
        return new AddressBookAddressClientQueryBuilder($this);
    }

    /**
     * @param array|int $categoryId
     * @param string $search
     * @param int $pageNum
     * @return Model\AddressRestfulModel[]|CmsApiIndexIterator|null
     */
    public function fetchAllBySearch($categoryId, $search, $pageNum = 0)
    {
        return $this->getBuilder()
            ->setSearch($search)
            ->setCategoryId($categoryId)
            ->getIndex($pageNum);
    }

    /**
     * @param array $queryParams
     * @return CmsApiIndexIterator|AddressRestfulModel[]
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function getIndexWithParams($queryParams)
    {
        $result = $this->loadIndexFromClient($this->basePath, $queryParams);
        return $result;
    }

    /**
     * @param int $bookId
     * @return CmsApiIndexIterator|AddressRestfulModel[]
     */
    public function getIndexByBookId($bookId)
    {
        $result = $this->getBuilder()->setBookId($bookId)->getIndex(-1);
        return $result;
    }
}
