<?php

namespace Cms\Client\Contract;

use Cms\Client\AbstractClient;
use Cms\Client\ClientFetchStrategy;
use Cms\Client\CmsApiIndexIterator;
use Cms\Client\Contract\Model\ContractRestfulModel;

/**
 * Class ContractClient
 * @package Cms\Client\Contract
 */
class ContractClient extends AbstractClient
{

    /** @var string */
    protected $basePath = 'contract';

    /** @var string */
    protected $fetchStrategy = ClientFetchStrategy::FETCH_ASYNC;

    /**
     * @param array $dataset
     * @return ContractRestfulModel
     */
    public function handleData($dataset = []) : ContractRestfulModel
    {
        return (new ContractRestfulModel())->populate($dataset, true);
    }

    /**
     * @return ContractClientQueryBuilder
     */
    public function getBuilder() : ContractClientQueryBuilder
    {
        $builder = new ContractClientQueryBuilder($this);
        return $builder;
    }

    /**
     * @param array $queryParams
     * @return CmsApiIndexIterator|ContractRestfulModel[]
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function getIndexWithParams($queryParams)
    {
        $result = $this->loadIndexFromClient($this->basePath, $queryParams);
        return $result;
    }

    /**
     * @param null $scopeId
     * @return CmsApiIndexIterator|ContractRestfulModel[]
     */
    public function getIndexByScope($scopeId = null)
    {
        $results = $this->getBuilder()
            ->setScopeId($scopeId)
            ->getIndex(-1);
        return $results;
    }

    /**
     * @param int $scopeId
     * @param \DateTime $beginAt
     * @param \DateTime $endAt
     * @return CmsApiIndexIterator|ContractRestfulModel[]
     */
    public function fetchItemByInterval($scopeId, \DateTime $beginAt, \DateTime $endAt)
    {
        $results = $this->getBuilder()
            ->setScopeId($scopeId)
            ->setBeginAt($beginAt)
            ->setEndAt($endAt)
            ->getIndex(-1);
        return $results;
    }
}
