<?php


namespace Cms\Client\Geodata;

use Cms\Client\AbstractClient;
use Cms\Client\CmsApiIndexIterator;
use Cms\Client\Geodata\Model\CityRestfulModel;

/**
 * Class CityClient
 * @package Cms\Client\Geodata
 */
class CityClient extends AbstractClient
{

    /** @var string */
    protected $basePath = 'geodata/city';

    /**
     * @param array $dataset
     * @return CityRestfulModel
     */
    public function handleData($dataset = [])
    {
        return (new CityRestfulModel())->populate($dataset);
    }

    /**
     * @param array $queryParams
     * @return CmsApiIndexIterator|CityRestfulModel[]
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function getIndexWithParams($queryParams)
    {
        $result = $this->loadIndexFromClient($this->basePath, $queryParams);
        return $result;
    }

    /**
     * @param string $osmId
     * @return \Cms\Client\CmsApiIndexIterator|\Cms\Client\Geodata\Model\CityRestfulModel[]
     */
    public function searchByOsmId($osmId)
    {
        return $this->getBuilder()
            ->setFilter('osm_id', $osmId)
            ->getIndex(-1);
    }

    /**
     * @param string $moveId
     * @return \Cms\Client\CmsApiIndexIterator|\Cms\Client\Geodata\Model\CityRestfulModel[]
     */
    public function searchByMoveId($moveId)
    {
        return $this->getBuilder()
            ->setFilter('move_id', $moveId)
            ->getIndex(-1);
    }

    /**
     * @param string $cityName
     * @param string $countryCode
     * @param string $admin1Code
     * @param string $admin2Code
     * @return \Cms\Client\CmsApiIndexIterator|\Cms\Client\Geodata\Model\CityRestfulModel[]
     */
    public function searchByName(
        $cityName,
        $countryCode = null,
        $admin1Code = null,
        $admin2Code = null
    ) {
        return $this->getBuilder()
            ->setFilter('name', $cityName)
            ->setFilter('country_alpha2', $countryCode)
            ->setFilter('admin1_code', $admin1Code)
            ->setFilter('admin2_code', $admin2Code)
            ->getIndex(-1);
    }

    /**
     * @param string $inseeCode
     * @return \Cms\Client\CmsApiIndexIterator|\Cms\Client\Geodata\Model\CityRestfulModel[]
     */
    public function searchByInsee($inseeCode)
    {
        return $this->getBuilder()
            ->setFilter('insee_code', $inseeCode)
            ->getIndex(-1);
    }

    /**
     * @param string $searchText
     * @param string $countryCode
     * @return \Cms\Client\CmsApiIndexIterator|\Cms\Client\Geodata\Model\CityRestfulModel[]
     */
    public function autocomplete($searchText, $countryCode = null)
    {
        return $this->getBuilder()
            ->setFilter('search', $searchText)
            ->setFilter('country_alpha2', $countryCode)
            ->getIndex(-1);
    }

    /**
     * @param int $countyId
     * @return \Cms\Client\CmsApiIndexIterator|\Cms\Client\Geodata\Model\CityRestfulModel[]
     */
    public function getIndexByAdmin(int $countyId)
    {
        return $this->getBuilder()
            ->setFilter('admin_id', $countyId)
            ->getIndex(-1);
    }
}
