<?php

namespace Cms\Client\Navigation\Model;

use Cms\LinkResource\FlattenResourcesAwareInterface;
use Cms\LinkResource\FlattenResourcesTrait;
use Cms\Model\Navigation\LinkResource\LinkResourceModel;
use Cms\Model\Navigation\NavigationItemModel;

/**
 * Class NavigationItemRestfulModel
 * @package Cms\Client\Navigation\Model
 */
class NavigationItemRestfulModel extends NavigationItemModel implements
    FlattenResourcesAwareInterface
{
    use FlattenResourcesTrait;

    /**
     * @param LinkResourceModel|array $resourceData
     * @return LinkResourceModel
     */
    public function handleResource($resourceData)
    {
        if (!$resourceData instanceof LinkResourceModel) {
            $resourceData = (new LinkResourceModel())->populate($resourceData, true);
        }
        return $resourceData;
    }
}
