<?php


namespace Cms\Model\Asset\Tag;

use Move\Filter\Filter;
use Move\Filter\Validator\AbstractDomainObjectStateValidator;
use Move\Specification\EnumSpecification;

/**
 * Class TagValidator
 * @package Cms\Model\Asset\Tag
 */
class TagValidator extends AbstractDomainObjectStateValidator
{

    /**
     * @return Filter
     */
    protected function createFilter()
    {
        // filtre du model
        $myFilter = new Filter([
            'name' => true,
            'type' => new EnumSpecification(TagType::class),
        ]);
        $myFilter->modify('type', function ($state) {
            return (string)$state;
        });

        return $myFilter;
    }
}
