<?php


namespace Move\Config;

/**
 * Class YamlExtParserWrapper
 * @package Move\Config
 */
class YamlExtParserWrapper
{

    /**
     * YamlExtParserWrapper constructor.
     */
    public function __construct()
    {
        if (!\function_exists('yaml_parse')) {
            throw new \RuntimeException('extension pecl yaml manquante');
        }
    }

    /**
     * @param string $yamlContent
     * @return array|false
     */
    public function parseString($yamlContent)
    {
        $yamlConfig = yaml_parse($yamlContent);
        return $yamlConfig;
    }

    /**
     * @param string $yamlContent
     * @return array|false
     */
    public function __invoke($yamlContent)
    {
        return $this->parseString($yamlContent);
    }
}
