<?php

namespace Move\Search;

use Elastica\Client;
use Elastica\Index;
use Move\Search\Analyzer\ElasticAnalyzer;

/**
 * Interface IndexBuilderInterface
 * @package Move\Search
 */
interface ElasticIndexBuilderInterface
{

    /**
     * @param \Elastica\Client $client
     * @param array|null $aliases
     * @param array|null $mappings
     * @return \Elastica\Index
     */
    public function createIndex(
        Client $client,
        array $aliases = null,
        array $mappings = null
    ) : Index;

    /**
     * @param \Elastica\Index $index
     * @param array|null $aliases
     * @return \Elastica\Index
     */
    public function createAliases(Index $index, array $aliases = null) : Index;

    /**
     * @param string $indexName
     * @return $this
     */
    public function setIndexName(string $indexName) : self;

    /**
     * @param \Move\Search\Analyzer\ElasticAnalyzer $analyzer
     * @return $this
     */
    public function setAnalizer(ElasticAnalyzer $analyzer) : self;

    /**
     * @param array $aliases
     * @return $this
     */
    public function setAliases(array $aliases) : self;

    /**
     * @param \Move\Search\ElasticMappingBuilderInterface $mappingBuilder
     * @return $this
     */
    public function setMappingBuilder(ElasticMappingBuilderInterface $mappingBuilder) : self;
}
