<?php


namespace Move\Utils;

/**
 * Class Gps
 * @package Move\Utils
 */
class Gps
{

    /**
     * @param float $latitude1
     * @param float $longitude1
     * @param float $latitude2
     * @param float $longitude2
     * @return array
     */
    public static function distance($latitude1, $longitude1, $latitude2, $longitude2)
    {
        $theta = $longitude1 - $longitude2;
        $miles = (sin(deg2rad($latitude1)) * sin(deg2rad($latitude2))) + (cos(deg2rad($latitude1)) * cos(deg2rad($latitude2)) * cos(deg2rad($theta)));
        $miles = acos($miles);
        $miles = rad2deg($miles);
        $miles = $miles * 60 * 1.1515;
        $feet = $miles * 5280;
        $yards = $feet / 3;
        $kilometers = $miles * 1.609344;
        $meters = $kilometers * 1000;
        return compact('kilometers', 'meters', 'yards', 'feet', 'miles');
    }

    /**
     * @param float $latitude1
     * @param float $longitude1
     * @param float $latitude2
     * @param float $longitude2
     * @return float
     */
    public static function distanceInKm($latitude1, $longitude1, $latitude2, $longitude2)
    {
        $data = self::distance($latitude1, $longitude1, $latitude2, $longitude2);
        return $data['kilometers'];
    }

    /**
     * @param float $latitude1
     * @param float $longitude1
     * @param float $latitude2
     * @param float $longitude2
     * @return float
     */
    public static function distanceInMeters($latitude1, $longitude1, $latitude2, $longitude2)
    {
        $data = self::distance($latitude1, $longitude1, $latitude2, $longitude2);
        return $data['meters'];
    }
}
