<?php

namespace Move\Restful;

use Move\ObjectMapper\ObjectTransformer;
use PHPUnit\Framework\TestCase;
use POM\MapperInterface;

/**
 * Class AbstractResourceServiceTest
 * @package Move\Restful
 */
class AbstractResourceServiceTest extends TestCase
{
    /** @var  AbstractResourceService | \PHPUnit_Framework_MockObject_MockObject */
    protected static $instance;

    /** @var ObjectTransformer $transformer */
    protected static $transformer;

    /** @var  MapperInterface $mapper */
    protected static $mapper;

    protected function setUp()
    {
        if (self::$instance === null) {
            self::$instance = $this->getMockForAbstractClass(AbstractResourceService::class);

            self::$transformer = $this
                ->getMockBuilder(ObjectTransformer::class)
                ->getMock();

            self::$mapper = $this->getMockBuilder(MapperInterface::class)
                ->getMock();
        }

    }

    /**
     * @expectedException \UnexpectedValueException
     */
    public function testGetTransformerWithException() {
        self::$instance->getMapper();
    }

    /**
     * @depends testGetTransformerWithException
     */
    public function testSetTransformer(){
        $instance = self::$instance->setTransformer(self::$transformer);
        $this->assertEquals(self::$instance, $instance);
    }

    /**
     * @depends  testSetTransformer
     */
    public function testGetTransformer() {
        $set = self::$instance->getTransformer();
        $this->assertEquals(self::$transformer, $set);
    }


    /**
     * @expectedException \UnexpectedValueException
     */
    public function testGetMapperWithException() {
        self::$instance->getMapper();
    }

    /**
     * @depends testGetMapperWithException
     */
    public function testSetMapper(){
        $instance = self::$instance->setMapper(self::$mapper);
        $this->assertEquals(self::$instance, $instance);
    }
    /**
     * @depends testSetMapper
     */
    public function testGetMapper() {
        $set = self::$instance->getMapper();
        $this->assertEquals(self::$mapper, $set);
    }
}
