<?php

namespace Move\Specification;

use PHPUnit\Framework\TestCase;

/**
 * Class SpecificationTest
 * @package Move\Specification
 */
class SpecificationTest extends TestCase
{
    /**
     *
     */
    public function testAvailableMethods()
    {
        /** @var Specification|\PHPUnit_Framework_MockObject_MockObject $instance */
        $instance = $this->createMock(Specification::class);

        /** @var Specification|\PHPUnit_Framework_MockObject_MockObject $instance2 */
        $instance2 = $this->createMock(Specification::class);

        $this->assertInstanceOf(
            NotSpecification::class,
            $instance->notSpec()
        );

        $this->assertInstanceOf(
            AndSpecification::class,
            $instance->andSpec($instance2)
        );

        $this->assertInstanceOf(
            OrSpecification::class,
            $instance->orSpec($instance2)
        );
    }
}
