<?php

namespace Cms\Bundle\Member;

use Cms\Client\Member\MemberClient;
use Move\ObjectMapper\ObjectTransformer;

/**
 * Class MemberLoginRegistry
 * @package Cms\Bundle\Member
 */
class MemberLoginService
{
    /** @var ObjectTransformer */
    private $memberTransformer;

    /** @var int */
    private $scopeId;

    /** @var \Cms\Client\Member\MemberClient */
    private $memberClient;

    /**
     * MemberLoginRegistry constructor.
     * @param int $scopeId
     * @param \Cms\Client\Member\MemberClient $memberClient
     * @param \Move\ObjectMapper\ObjectTransformer $memberTransformer
     */
    public function __construct(
        int $scopeId,
        MemberClient $memberClient,
        ObjectTransformer $memberTransformer
    ) {
        $this->scopeId = $scopeId;
        $this->memberClient = $memberClient;
        $this->memberTransformer = $memberTransformer;
    }

    /**
     * @return int
     */
    public function getScopeId() : int
    {
        return $this->scopeId;
    }

    /**
     * @return \Cms\Client\Member\MemberClient
     */
    public function getMemberClient() : MemberClient
    {
        return $this->memberClient;
    }

    /**
     * @return \Move\ObjectMapper\ObjectTransformer
     */
    public function getMemberTransformer() : ObjectTransformer
    {
        return $this->memberTransformer;
    }
}
