<?php


namespace Move\Http\Strategy\Handler;

use Move\Http\RequestUtils;
use Move\Http\Strategy\ExceptionHandler\ExceptionHandlerInterface;
use Move\Http\Strategy\ResponseFactory;
use Move\Http\Strategy\Serializer\CsvLeagueSerializer;
use Move\Http\Strategy\Serializer\SerializerInterface;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;

/**
 * Class CsvHandlerService
 * @package Move\Http\Strategy\Handler
 */
class CsvHandlerService extends HandlerServiceAbstract implements HandlerServiceInterface
{

    /**
     * JsonHandlerService constructor.
     * @param SerializerInterface $serializer
     * @param ExceptionHandlerInterface|null $exceptionHandler
     * @throws \InvalidArgumentException
     */
    public function __construct(SerializerInterface $serializer, $exceptionHandler = null)
    {
        // check du type de serializer
        if (!$serializer instanceof CsvLeagueSerializer) {
            throw new \InvalidArgumentException('Serializer must implement CsvLeagueSerializer');
        }
        parent::__construct($serializer, $exceptionHandler);
    }


    /**
     * @inheritdoc
     */
    public function isSatisfiedBy($request) : bool
    {
        if (!$request instanceof ServerRequestInterface) {
            return false;
        }

        // check du type
        $mime = 'text/csv';
        $pathMatch = preg_match('@\.(?:csv|xls)$@', $request->getUri()->getPath());
        return (RequestUtils::isAcceptable($request, $mime) && $pathMatch) || $pathMatch;
    }

    /**
     * @inheritdoc
     * @throws \InvalidArgumentException
     */
    public function determineResponse($dataset, ResponseInterface $response)
    {
        if (!$dataset instanceof ResponseFactory) {
            $dataset = new ResponseFactory($dataset);
        }
        $response = $dataset->determineResponse($this->getSerializer(), $response);
        // ajout le header json a la reponse
        return $response
            ->withHeader('Content-Type', 'text/csv')
            ->withHeader('Content-Description', 'File Transfer');
    }
}
