<?php

namespace Move\Jato\Command;

use PHPUnit\Framework\TestCase;

/**
 * Class FetchAllModelCommandTest
 * @package Move\Jato\Command
 */
class FetchAllModelCommandTest extends TestCase
{
    /**
     * @return FetchAllModelCommand
     */
    public function testConstruct() : FetchAllModelCommand
    {
        $database = 'SSCF_CS2002';
        $makeKey = 'Aston Martin';
        $modelKey = 'DB11';
        $command = new FetchAllModelCommand($database, $makeKey, $modelKey);

        $makeKeyTest = $command->getMakeKey();
        $modelKeyTest = $command->getModelKey();
        $databaseTest = $command->getDatabase();

        $this->assertEquals($database, $databaseTest, 'Database not equal');
        $this->assertEquals($makeKey, $makeKeyTest, 'MakeKey not equal');
        $this->assertEquals($modelKey, $modelKeyTest, 'ModelKey not equal');

        return $command;
    }

    /**
     * @depends testConstruct
     * @param FetchAllModelCommand $command
     */
    public function testGetMakeKey(FetchAllModelCommand $command)
    {
        $result = $command->getMakeKey();
        $this->assertInternalType('string', $result, 'MakeKey not a string');
    }

    /**
     * @depends testConstruct
     * @param FetchAllModelCommand $command
     */
    public function testSetMakeKey(FetchAllModelCommand $command)
    {
        $new = 'new';
        $command->setMakeKey($new);
        $result = $command->getMakeKey();

        $this->assertEquals($new, $result, 'MakeKey not set');
    }

    /**
     * @depends testConstruct
     * @param FetchAllModelCommand $command
     */
    public function testGetModelKey(FetchAllModelCommand $command)
    {
        $result = $command->getModelKey();
        $this->assertInternalType('string', $result, 'ModelKey not a string');
    }

    /**
     * @depends testConstruct
     * @param FetchAllModelCommand $command
     */
    public function testSetModelKey(FetchAllModelCommand $command)
    {
        $new = 'new';
        $command->setModelKey($new);
        $result = $command->getModelKey();

        $this->assertEquals($new, $result, 'ModelKey not set');
    }

}