<?php

namespace Cms\Transformer\Decorator;

use Cms\Model\I18nHelper;
use Move\ObjectMapper\ObjectTransformer;

/**
 * Class GeodataTransformerDecorator
 * @package Cms\Transformer\Decorator
 */
class GeodataTransformerDecorator implements TransformerDecoratorInterface
{
    /** @var \Cms\Client\Geodata\Model\AdminRestfulModel[] */
    private $listGeodataAdmin;

    /**
     * GeodataTransformerDecorator constructor.
     * @param array $listGeodataAdmin
     */
    public function __construct(array $listGeodataAdmin = [])
    {
        $this->listGeodataAdmin = $listGeodataAdmin;
    }

    /**
     * @param mixed $object
     * @return callable
     * @throws \InvalidArgumentException
     */
    public function getDatasetDecorator($object) : callable
    {
        return function (array $source) {
            foreach ($this->listGeodataAdmin as $geoAdmin) {
                if ($geoAdmin->code_concat === $source['address_loc']['admin2_code_concat']) {
                    $source['admin'] = (new ObjectTransformer())->transform($geoAdmin);
                    $source['admin_name'] = I18nHelper::translateObject($geoAdmin, 'name');
                    $source['admin_code'] = $geoAdmin->code_simple;
                    break;
                }
            }
            return $source;
        };
    }
}
