<?php

namespace Move\Command;

use Move\Filter\Validator\StateValidatorInterface;
use Move\Utils\Reflection;
use PHPUnit\Framework\TestCase;
use POM\DomainObjectInterface;
use POM\MapperAbstract;
use POM\Service\AdapterInterface;

/**
 * Class AbstractCommandHandlerTest
 * @package Move\Command
 */
class AbstractCommandHandlerTest extends TestCase
{
    /** @var AbstractCommandHandler $instance */
    private static $instance;

    public function testSetValidator(/*StateValidatorInterface $validator*/)
    {
        /** @var StateValidatorInterface $validator */
        $validator = $this->getMockBuilder(StateValidatorInterface::class)->getMock();
        self::$instance->setValidator($validator);

        $this->assertEquals($validator, Reflection::getValue(self::$instance, 'validator'));
    }

    public function testHandleCreate(/*CreateCommand $command*/)
    {

    }

    public function testHandleUpdate(/*UpdateCommand $command*/)
    {

    }

    public function testHandleDelete(/*DeleteCommand $command*/)
    {

    }

    public function testHandleFetch(/*FetchCommand $command*/)
    {

    }

    protected function setUp()
    {
        if (self::$instance === null) {

            $adapter = $this->getMockForAbstractClass(AdapterInterface::class);

            $mapper = $this
                ->getMockBuilder(MapperAbstract::class)
                ->setConstructorArgs([$adapter, '', ''])
                ->getMock();

            $object = $this->getMockBuilder(DomainObjectInterface::class)
                ->getMock();

            self::$instance = $this->getMockForAbstractClass(AbstractCommandHandler::class);

            self::$instance->expects($this->any())
                ->method('getMapper')
                ->willReturn($mapper);

            self::$instance->expects($this->any())
                ->method('handleData')
                ->willReturn($object);

        }
    }
}
