<?php

namespace Cms\Bundle\Member\Exception;

use Cms\Bundle\Member\MemberErrorCode;

/**
 * Class FieldMissingException
 * @package Cms\Bundle\Member\Exception
 */
class FieldMissingException extends FieldException
{

    /**
     * FieldMissingException constructor.
     * @param string $fieldname
     * @param \Exception|null $previous
     */
    public function __construct(
        string $fieldname,
        \Exception $previous = null
    ) {
        parent::__construct($fieldname, MemberErrorCode::FIELD_MISSING, $previous);
    }
}
